########### Merge Event onset permutations ###########
# This function will iterate through files of the 3_Event_onset_Permutation and merge them into one collapsed data frame.

# Main function ---------------------------------------------------------------------------------------------------
merge_permutation <- function(config.file = './R/config.R') {
  tryCatch({
    
    # Load libraries
    suppressWarnings(library(tidyverse))
    suppressWarnings(library(futile.logger))
    
    suppressWarnings(library(furrr))
    plan(multiprocess) #multiprocess
    
    # Load config file
    source(config.file)
    source('./R/4_merge_permutations_functions.R')
    
    flog.logger(name = log.name, threshold = threshold, appender = appender.tee(paste0(output.folder, log.name, ".log")))
    flog.threshold(threshold, name = log.name)
    
    flog.info(paste0("Initializing: ", format(Sys.Date(), "%d %B, %Y")), name = log.name)
    flog.info("Loading original data....", name = log.name)
    
    Data_original <- read_rds(path = paste0(output.folder, Units.thresholded))
    
    # filter units 
    flog.info("Filtering original data....", name = log.name)
    
    Filtered.data <- Data_original %>%
      filter(Direction %in% c("Up", "Down", "Nonresponder"))
    
    Data_original <- NULL
    
    flog.info("Averagin original data....", name = log.name)
    Filtered.data.avg <- average_data(Filtered.data, iteration = 0)
    
    Filtered.data.iter <- Filtered.data %>% 
      select(-Direction, -z.score)
    
    #### iter through files ####
    flog.info("Creating file list", name = log.name)
    
    file.list <- dir(path = output.folder, pattern = paste0("._",Units.thresholded))
    
    flog.info("Processing permuted files", name = log.name)
    iteration <- seq(from = 1, to = length(file.list), by = 1)
    
    Data.permutation <- future_map2(file.list, iteration, 
                                        merge_permutation_files, 
                                        Filtered.data.iter, output.folder,group.columns)
    Data.permutation <- transpose(Data.permutation)
    
    flog.info("Merging original with permuted file", name = log.name)

    Data.all <- Data.permutation$Time.data %>% bind_rows(.) %>% bind_rows(Filtered.data.avg, .)
    
    flog.info("Writing time file", name = log.name)
    write_rds(Data.all , path = paste0(output.folder, "Permutation_merge_zscore.rds"))

    flog.info("Writing unit direction file", name = log.name)
    
    Data.all <- Data.permutation$Direction.data %>% 
      bind_rows(.) %>% 
      bind_rows(Filtered.data %>% select(-norm.time, -Time.period, -z.score) %>% unique() %>%
                  mutate(iteration = 0), .)
    
    write_rds(Data.all, path = paste0(output.folder, "Permutation_merge_directions.rds"))
    
  }, error = function(e) {
    flog.error("ERROR!", name = log.name)
    flog.error(e, name = log.name)
  })
}



